////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Server::Start(int LocalPort)
{
	char LocalServerName[257];

	SOCKADDR_IN LocalListenSocketAddress;	  // Socket Address Of Local Server

	DWORD Result = 0;

	WORD WSARequiredVersion;				  // Windows Socket Required Version
	WSADATA WSAData;						  // Windows Socket Required Version
	WSADATA *WSAPointerData;				  // Windows Socket Required Version

	// -------- WINSOCK STARTUP --------
	WSARequiredVersion = 0x0101; // Version 1.1
	WSAPointerData = &WSAData;
	Result = WSAStartup(WSARequiredVersion, WSAPointerData);
	if(Result != 0)
	{
		// Start- WSAStartup Error.
		return false;
	}

    if(LocalPort == -1)
        return true;

	// -------- Get Local Host Name --------
	Result = gethostname(LocalServerName, sizeof(LocalServerName));
	if(Result == SOCKET_ERROR)
	{
		// Start- GetHostName Error.
		return false;
	}

	// ----- Fill In The Address Structure For Local Server -----
	LocalListenSocketAddress.sin_family = AF_INET;		   // Address Family
	LocalListenSocketAddress.sin_addr.s_addr = INADDR_ANY; // Let socket Library Assign Address
	LocalListenSocketAddress.sin_port = htons(LocalPort);  // Port Number

	// ----- Create A TCP/IP Stream Socket To "Listen" with -----
	LocalListenSocket = socket (AF_INET,SOCK_STREAM,IPPROTO_TCP );
	if(LocalListenSocket == INVALID_SOCKET)
	{
		// Start- Socket Error.
		return false;
	}

	// -------- Bind The Name To The Socket --------
	Result = bind (LocalListenSocket,(SOCKADDR*)&LocalListenSocketAddress,sizeof(struct sockaddr));
	if(Result == SOCKET_ERROR)
	{
		// Start- Bind Error.
		closesocket(LocalListenSocket);
		return false;
	}

	// -------- Set The Socket To Listen --------
	Result = listen(LocalListenSocket,1024);
	if(Result == SOCKET_ERROR)
	{
		// Start- Listen Error.
		closesocket(LocalListenSocket);
		return false;
	}

    CreateNewTCPThread();

    char StatusTemp[255];
    sprintf(StatusTemp, "Server started. Listening on port %d.", glListenPort);
    WriteLog(StatusTemp);
    WriteLog(LBSEPERATOR);
    WriteLog("");

	// Start- Success

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

